#ifndef CE2_TCT_ECC_h
#define CE2_TCT_ECC_h

/*
*  \brief This file contains tests for ECC (Elliptic Curve Cryptography) 
*         CryptoEngine2 API functions; 
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All rights reserved.
*/

#include "CE2_TST_Config.h"

/*
  \brief 
  CE2_TST_ECC_KeyExportImport() - Verify functionality of functions:
  1. CE2_ECPKI_GenKeyPair();
  2. CE2_ECPKI_ExportPublKey();
  3. CE2_ECPKI_BuildPublKey();
  4. CE2_ECPKI_ExportPrivKey();
  5. CE2_ECPKI_BuildPrivKey();

  @param[in] out - output stream for logs;
  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*/
DxStatus CE2_TST_ECC_KeyExportImport(FILE *out);

/*
  \brief 
  CE2_TST_ECC_DH() - Verify functionality of functions:
  1. CE2_ECDH_SVDP_DH();

  @param[in] out - output stream for logs;
  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*/
DxStatus CE2_TST_ECC_DH(FILE *out);

/*
  \brief 
  CE2_TST_ECC_ElGamal_EncDec() - Verify functionality of functions:
  1. CE2_ECPKI_ELGAMAL_Encrypt();
  2. CE2_ECPKI_ELGAMAL_Decrypt();

  @param[in] out - output stream for logs;
  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*/
DxStatus CE2_TST_ECC_ElGamal_EncDec(FILE *out);

/*
\brief 
  CE2_TST_ECC_ECDSA() - Verify functionality of functions:
  1. CE2_ECDSA_Sign();
  2. CE2_ECDSA_Verify();

  @param[in] out - output stream for logs;
  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*/
DxStatus CE2_TST_ECC_ECDSA(FILE *out);

// Anna 28/3/2007 - for debug purpose 
int bugCheck ();

DxStatus BugCheck_2007_03_28(FILE *out);
DxStatus BugCheck_2007_04_10(FILE *out);
DxStatus BugCheck_2007_04_26(FILE *out);

DxStatus CE2_TST_ECC_ECDSA_ZeroMessage(FILE *out);

#endif /*CE2_TCT_ECC_h*/
